using System;
using System.Collections.Generic;
using System.Text;

namespace Inheritance
{
   public abstract class Animal
   {
      private string color;

      public Animal()
      {
         color = "Niebieski";
      }

      public virtual void MakeNoise()
      {
         Console.WriteLine("Cos przypominajacego ryk!");
      }

      public string Color
      {
         get { return color; }
         set { color = value; }
      }
   }

   public class Cat : Animal
   {
      public Cat()
         : base()
      {
         Color = "Czarny";
      }

      public new void MakeNoise()
      {
         Console.WriteLine("Zamiaucza.");
      }
   }

   public class Lion : Cat
   {
      public Lion()
         : base()
      {
         Color = "Zlty";
      }

      public new void MakeNoise()
      {
         Console.WriteLine("ROOooWWRrrRR!!");
      }
   }

   class Program
   {
      static void Main(string[] args)
      {
         Cat c = new Cat();
         c.MakeNoise();

         Lion l = new Lion();
         l.MakeNoise();

         Console.ReadLine();
      }
   }
}
